/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.auth;

import ch.ethz.ssh2.InteractiveCallback;
import ch.ethz.ssh2.auth.AgentIdentity;
import ch.ethz.ssh2.auth.AgentProxy;
import ch.ethz.ssh2.crypto.PEMDecoder;
import ch.ethz.ssh2.packets.PacketServiceAccept;
import ch.ethz.ssh2.packets.PacketServiceRequest;
import ch.ethz.ssh2.packets.PacketUserauthBanner;
import ch.ethz.ssh2.packets.PacketUserauthFailure;
import ch.ethz.ssh2.packets.PacketUserauthInfoRequest;
import ch.ethz.ssh2.packets.PacketUserauthInfoResponse;
import ch.ethz.ssh2.packets.PacketUserauthRequestInteractive;
import ch.ethz.ssh2.packets.PacketUserauthRequestNone;
import ch.ethz.ssh2.packets.PacketUserauthRequestPassword;
import ch.ethz.ssh2.packets.PacketUserauthRequestPublicKey;
import ch.ethz.ssh2.packets.TypesWriter;
import ch.ethz.ssh2.signature.DSAPrivateKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.DSASignature;
import ch.ethz.ssh2.signature.RSAPrivateKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import ch.ethz.ssh2.signature.RSASignature;
import ch.ethz.ssh2.transport.ClientTransportManager;
import ch.ethz.ssh2.transport.MessageHandler;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class AuthenticationManager
implements MessageHandler {
    private ClientTransportManager tm;
    private final List<byte[]> packets = new ArrayList<byte[]>();
    private boolean connectionClosed = false;
    private String banner;
    private String[] remainingMethods = new String[0];
    private boolean isPartialSuccess = false;
    private boolean authenticated = false;
    private boolean initDone = false;

    public AuthenticationManager(ClientTransportManager tm) {
        this.tm = tm;
    }

    boolean methodPossible(String methName) {
        if (this.remainingMethods == null) {
            return false;
        }
        String[] stringArray = this.remainingMethods;
        int n2 = this.remainingMethods.length;
        int n3 = 0;
        while (n3 < n2) {
            String remainingMethod = stringArray[n3];
            if (remainingMethod.compareTo(methName) == 0) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] deQueue() throws IOException {
        List<byte[]> list = this.packets;
        synchronized (list) {
            while (this.packets.size() == 0) {
                if (this.connectionClosed) {
                    throw new IOException("The connection is closed.", this.tm.getReasonClosedCause());
                }
                try {
                    this.packets.wait();
                }
                catch (InterruptedException e2) {
                    throw new InterruptedIOException(e2.getMessage());
                }
            }
            byte[] res = this.packets.get(0);
            this.packets.remove(0);
            return res;
        }
    }

    byte[] getNextMessage() throws IOException {
        byte[] msg;
        while ((msg = this.deQueue())[0] == 53) {
            PacketUserauthBanner sb = new PacketUserauthBanner(msg, 0, msg.length);
            this.banner = sb.getBanner();
        }
        return msg;
    }

    public String[] getRemainingMethods(String user2) throws IOException {
        this.initialize(user2);
        return this.remainingMethods;
    }

    public String getBanner() {
        return this.banner;
    }

    public boolean getPartialSuccess() {
        return this.isPartialSuccess;
    }

    private boolean initialize(String user2) throws IOException {
        if (!this.initDone) {
            this.tm.registerMessageHandler(this, 0, 255);
            PacketServiceRequest sr = new PacketServiceRequest("ssh-userauth");
            this.tm.sendMessage(sr.getPayload());
            byte[] msg = this.getNextMessage();
            new PacketServiceAccept(msg, 0, msg.length);
            PacketUserauthRequestNone urn = new PacketUserauthRequestNone("ssh-connection", user2);
            this.tm.sendMessage(urn.getPayload());
            msg = this.getNextMessage();
            this.initDone = true;
            if (msg[0] == 52) {
                this.authenticated = true;
                this.tm.removeMessageHandler(this, 0, 255);
                return true;
            }
            if (msg[0] == 51) {
                PacketUserauthFailure puf = new PacketUserauthFailure(msg, 0, msg.length);
                this.remainingMethods = puf.getAuthThatCanContinue();
                this.isPartialSuccess = puf.isPartialSuccess();
                return false;
            }
            throw new IOException("Unexpected SSH message (type " + msg[0] + ")");
        }
        return this.authenticated;
    }

    public boolean authenticatePublicKey(String user2, AgentProxy proxy) throws IOException {
        this.initialize(user2);
        for (AgentIdentity identity : proxy.getIdentities()) {
            boolean success = this.authenticatePublicKey(user2, identity);
            if (!success) continue;
            return true;
        }
        return false;
    }

    boolean authenticatePublicKey(String user2, AgentIdentity identity) throws IOException {
        if (!this.methodPossible("publickey")) {
            throw new IOException("Authentication method publickey not supported by the server at this stage.");
        }
        byte[] pubKeyBlob = identity.getPublicKeyBlob();
        if (pubKeyBlob == null) {
            return false;
        }
        TypesWriter tw = new TypesWriter();
        byte[] H = this.tm.getSessionIdentifier();
        tw.writeString(H, 0, H.length);
        tw.writeByte(50);
        tw.writeString(user2);
        tw.writeString("ssh-connection");
        tw.writeString("publickey");
        tw.writeBoolean(true);
        tw.writeString(identity.getAlgName());
        tw.writeString(pubKeyBlob, 0, pubKeyBlob.length);
        byte[] msg = tw.getBytes();
        byte[] response = identity.sign(msg);
        PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, identity.getAlgName(), pubKeyBlob, response);
        this.tm.sendMessage(ua.getPayload());
        byte[] ar = this.getNextMessage();
        if (ar[0] == 52) {
            this.authenticated = true;
            this.tm.removeMessageHandler(this, 0, 255);
            return true;
        }
        if (ar[0] == 51) {
            PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
            this.remainingMethods = puf.getAuthThatCanContinue();
            this.isPartialSuccess = puf.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
    }

    public boolean authenticatePublicKey(String user2, char[] PEMPrivateKey, String password, SecureRandom rnd) throws IOException {
        byte[] ar;
        block10: {
            block9: {
                try {
                    byte[] pk_enc;
                    Object pk;
                    this.initialize(user2);
                    if (!this.methodPossible("publickey")) {
                        throw new IOException("Authentication method publickey not supported by the server at this stage.");
                    }
                    Object key = PEMDecoder.decode(PEMPrivateKey, password);
                    if (key instanceof DSAPrivateKey) {
                        pk = (DSAPrivateKey)key;
                        pk_enc = DSASHA1Verify.encodeSSHDSAPublicKey(((DSAPrivateKey)pk).getPublicKey());
                        TypesWriter tw = new TypesWriter();
                        byte[] H = this.tm.getSessionIdentifier();
                        tw.writeString(H, 0, H.length);
                        tw.writeByte(50);
                        tw.writeString(user2);
                        tw.writeString("ssh-connection");
                        tw.writeString("publickey");
                        tw.writeBoolean(true);
                        tw.writeString("ssh-dss");
                        tw.writeString(pk_enc, 0, pk_enc.length);
                        byte[] msg = tw.getBytes();
                        DSASignature ds = DSASHA1Verify.generateSignature(msg, (DSAPrivateKey)pk, rnd);
                        byte[] ds_enc = DSASHA1Verify.encodeSSHDSASignature(ds);
                        PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, "ssh-dss", pk_enc, ds_enc);
                        this.tm.sendMessage(ua.getPayload());
                    } else if (key instanceof RSAPrivateKey) {
                        pk = (RSAPrivateKey)key;
                        pk_enc = RSASHA1Verify.encodeSSHRSAPublicKey(((RSAPrivateKey)pk).getPublicKey());
                        TypesWriter tw = new TypesWriter();
                        byte[] H = this.tm.getSessionIdentifier();
                        tw.writeString(H, 0, H.length);
                        tw.writeByte(50);
                        tw.writeString(user2);
                        tw.writeString("ssh-connection");
                        tw.writeString("publickey");
                        tw.writeBoolean(true);
                        tw.writeString("ssh-rsa");
                        tw.writeString(pk_enc, 0, pk_enc.length);
                        byte[] msg = tw.getBytes();
                        RSASignature ds = RSASHA1Verify.generateSignature(msg, (RSAPrivateKey)pk);
                        byte[] rsa_sig_enc = RSASHA1Verify.encodeSSHRSASignature(ds);
                        PacketUserauthRequestPublicKey ua = new PacketUserauthRequestPublicKey("ssh-connection", user2, "ssh-rsa", pk_enc, rsa_sig_enc);
                        this.tm.sendMessage(ua.getPayload());
                    } else {
                        throw new IOException("Unknown private key type returned by the PEM decoder.");
                    }
                    ar = this.getNextMessage();
                    if (ar[0] != 52) break block9;
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                catch (IOException e2) {
                    this.tm.close(e2);
                    throw new IOException("Publickey authentication failed.", e2);
                }
            }
            if (ar[0] != 51) break block10;
            PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
            this.remainingMethods = puf.getAuthThatCanContinue();
            this.isPartialSuccess = puf.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
    }

    public boolean authenticateNone(String user2) throws IOException {
        try {
            this.initialize(user2);
            return this.authenticated;
        }
        catch (IOException e2) {
            this.tm.close(e2);
            throw new IOException("None authentication failed.", e2);
        }
    }

    public boolean authenticatePassword(String user2, String pass) throws IOException {
        byte[] ar;
        block6: {
            block5: {
                try {
                    this.initialize(user2);
                    if (!this.methodPossible("password")) {
                        throw new IOException("Authentication method password not supported by the server at this stage.");
                    }
                    PacketUserauthRequestPassword ua = new PacketUserauthRequestPassword("ssh-connection", user2, pass);
                    this.tm.sendMessage(ua.getPayload());
                    ar = this.getNextMessage();
                    if (ar[0] != 52) break block5;
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                catch (IOException e2) {
                    this.tm.close(e2);
                    throw new IOException("Password authentication failed.", e2);
                }
            }
            if (ar[0] != 51) break block6;
            PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
            this.remainingMethods = puf.getAuthThatCanContinue();
            this.isPartialSuccess = puf.isPartialSuccess();
            return false;
        }
        throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean authenticateInteractive(String user2, String[] submethods, InteractiveCallback cb) throws IOException {
        try {
            this.initialize(user2);
            if (!this.methodPossible("keyboard-interactive")) {
                throw new IOException("Authentication method keyboard-interactive not supported by the server at this stage.");
            }
            if (submethods == null) {
                submethods = new String[]{};
            }
            PacketUserauthRequestInteractive ua = new PacketUserauthRequestInteractive("ssh-connection", user2, submethods);
            this.tm.sendMessage(ua.getPayload());
            while (true) {
                String[] responses;
                byte[] ar;
                if ((ar = this.getNextMessage())[0] == 52) {
                    this.authenticated = true;
                    this.tm.removeMessageHandler(this, 0, 255);
                    return true;
                }
                if (ar[0] == 51) {
                    PacketUserauthFailure puf = new PacketUserauthFailure(ar, 0, ar.length);
                    this.remainingMethods = puf.getAuthThatCanContinue();
                    this.isPartialSuccess = puf.isPartialSuccess();
                    return false;
                }
                if (ar[0] != 60) {
                    throw new IOException("Unexpected SSH message (type " + ar[0] + ")");
                }
                PacketUserauthInfoRequest pui = new PacketUserauthInfoRequest(ar, 0, ar.length);
                try {
                    responses = cb.replyToChallenge(pui.getName(), pui.getInstruction(), pui.getNumPrompts(), pui.getPrompt(), pui.getEcho());
                }
                catch (Exception e2) {
                    throw new IOException("Exception in callback.", e2);
                }
                if (responses == null) {
                    throw new IOException("Your callback may not return NULL!");
                }
                PacketUserauthInfoResponse puir = new PacketUserauthInfoResponse(responses);
                this.tm.sendMessage(puir.getPayload());
            }
        }
        catch (IOException e3) {
            this.tm.close(e3);
            throw new IOException("Keyboard-interactive authentication failed.", e3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(byte[] msg, int msglen) throws IOException {
        List<byte[]> list = this.packets;
        synchronized (list) {
            if (msg == null) {
                this.connectionClosed = true;
            } else {
                byte[] tmp = new byte[msglen];
                System.arraycopy(msg, 0, tmp, 0, msglen);
                this.packets.add(tmp);
            }
            this.packets.notifyAll();
            if (this.packets.size() > 5) {
                this.connectionClosed = true;
                throw new IOException("Error, peer is flooding us with authentication packets.");
            }
        }
    }
}

