/*
 * Decompiled with CFR 0.152.
 */
package cc.sferalabs.libs.iono_pi.onewire;

import cc.sferalabs.libs.iono_pi.IonoPi;
import cc.sferalabs.libs.iono_pi.jni.IonoPiJNI;
import cc.sferalabs.libs.iono_pi.onewire.OneWireBusDevice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OneWire {
    public List<OneWireBusDevice> getBusDevices() throws IOException {
        String[] ids = IonoPiJNI.ionoPi1WireBusGetDevices();
        if (ids == null) {
            throw new IOException("Devices discovery error. Have you enabled the 1-wire bus?");
        }
        ArrayList<OneWireBusDevice> list = new ArrayList<OneWireBusDevice>(ids.length);
        for (String id : ids) {
            list.add(new OneWireBusDevice(id));
        }
        return list;
    }

    public int[] maxDetectRead(IonoPi.DigitalIO ttl, int attempts) throws IOException {
        int[] temp_rh = IonoPiJNI.ionoPi1WireMaxDetectRead(ttl.pin, attempts);
        if (temp_rh == null) {
            throw new IOException("Could not read");
        }
        return temp_rh;
    }
}

