/*
 * Decompiled with CFR 0.152.
 */
package cc.sferalabs.libs.iono_pi.jni;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public abstract class IonoPiJNIConstants {
    public static final int TTL1 = 7;
    public static final int TTL2 = 25;
    public static final int TTL3 = 28;
    public static final int TTL4 = 29;
    public static final int DI1 = 27;
    public static final int DI2 = 24;
    public static final int DI3 = 23;
    public static final int DI4 = 26;
    public static final int DI5 = 22;
    public static final int DI6 = 21;
    public static final int OC1 = 1;
    public static final int OC2 = 6;
    public static final int OC3 = 5;
    public static final int O1 = 0;
    public static final int O2 = 2;
    public static final int O3 = 3;
    public static final int O4 = 4;
    public static final int LED = 11;
    public static final int AI1 = 64;
    public static final int AI2 = 0;
    public static final int AI3 = 128;
    public static final int AI4 = 192;
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    public static final int ON = 1;
    public static final int OFF = 0;
    public static final int CLOSED = 1;
    public static final int OPEN = 0;
    public static final int INT_EDGE_FALLING = 1;
    public static final int INT_EDGE_RISING = 2;
    public static final int INT_EDGE_BOTH = 3;

    static void init() throws IOException {
        IonoPiJNIConstants.loadNativeLibrary();
        IonoPiJNIConstants.ionoPiSetup();
    }

    private static void loadNativeLibrary() throws IOException {
        Path tempLib = Files.createTempFile("ionoPiJNI", ".so", new FileAttribute[0]);
        try (InputStream in = IonoPiJNIConstants.class.getResourceAsStream("libionoPiJNI.so");){
            Files.copy(in, tempLib, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(tempLib.toAbsolutePath().toString());
        Files.delete(tempLib);
    }

    public static native int ionoPiSetup();

    public static native void ionoPiPinMode(int var0, int var1);

    public static native void ionoPiDigitalWrite(int var0, int var1);

    public static native int ionoPiDigitalRead(int var0);

    public static native float ionoPiAnalogRead(int var0);
}

