/*
 * Decompiled with CFR 0.152.
 */
package cc.sferalabs.libs.iono_pi.jni;

import cc.sferalabs.libs.iono_pi.DigitalInputListener;
import cc.sferalabs.libs.iono_pi.IonoPi;
import cc.sferalabs.libs.iono_pi.jni.InputListenerCouple;
import cc.sferalabs.libs.iono_pi.jni.WiegandListenerJNIWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;

public abstract class IonoPiJNI {
    private static final Map<Integer, InputListenerCouple> listeners = new HashMap<Integer, InputListenerCouple>(6);
    private static Boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() throws Exception {
        Boolean bl = initialized;
        synchronized (bl) {
            if (!initialized.booleanValue()) {
                IonoPiJNI.loadNativeLibrary();
                if (!IonoPiJNI.ionoPiSetup()) {
                    throw new Exception("Iono Pi setup error");
                }
                initialized = true;
            }
        }
    }

    private static void loadNativeLibrary() throws IOException {
        Path tempLib = Files.createTempFile("ionoPiJNI", ".so", new FileAttribute[0]);
        try (InputStream in = IonoPiJNI.class.getResourceAsStream("libionoPiJNI.so");){
            Files.copy(in, tempLib, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(tempLib.toAbsolutePath().toString());
        Files.delete(tempLib);
    }

    private static native boolean ionoPiSetup();

    public static native void ionoPiPinMode(int var0, int var1);

    public static native void ionoPiDigitalWrite(int var0, int var1);

    public static native int ionoPiDigitalRead(int var0);

    public static native void ionoPiSetDigitalDebounce(int var0, int var1);

    public static native int ionoPiAnalogRead(int var0);

    public static native float ionoPiVoltageRead(int var0);

    private static native int ionoPiDigitalInterrupt(int var0, int var1, boolean var2);

    public static void ionoPiSetDigitalInputListener(IonoPi.DigitalInput di, int mode, DigitalInputListener listener) {
        if (listener == null) {
            listeners.put(di.pin, null);
            IonoPiJNI.ionoPiDigitalInterrupt(di.pin, mode, false);
        } else {
            listeners.put(di.pin, new InputListenerCouple(di, listener));
            IonoPiJNI.ionoPiDigitalInterrupt(di.pin, mode, true);
        }
    }

    private static void digitalInterruptCallback(int di, int value) {
        InputListenerCouple il = listeners.get(di);
        if (il != null) {
            il.listener.onChange(il.di, value == 1);
        }
    }

    public static native String[] ionoPi1WireBusGetDevices();

    public static native int ionoPi1WireBusReadTemperature(String var0, int var1, int var2);

    public static native int[] ionoPi1WireMaxDetectRead(int var0, int var1);

    public static native boolean ionoPiWiegandMonitor(int var0, WiegandListenerJNIWrapper var1);

    public static native boolean ionoPiWiegandStop(int var0);
}

